<?php
use yii\helpers\Url;
use yii\helpers\Html;
use yii\bootstrap\Modal;
use kartik\grid\GridView;
use johnitvn\ajaxcrud\CrudAsset; 
use johnitvn\ajaxcrud\BulkButtonWidget;
use backend\models\Admin;

/* @var $this yii\web\View */
/* @var $searchModel backend\models\BotsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$r = explode('/',Yii::$app->request->url);
if($r[1]=='honeypots'){
    $this->title = 'Honeypots';
}elseif($r[1]=='testbots'){
    $this->title = 'Testbots';
}else{
    $this->title = 'Bots';
}

$autorefresh = Admin::getAdminSettingValue('autorefresh');
    
if($autorefresh===false){
    Admin::setAdminSettingValue('autorefresh',30);
}
$autorefresh = Admin::getAdminSettingValue('autorefresh');

$this->params['breadcrumbs'][] = $this->title;
$ar = ($autorefresh===false) ? 30 : $autorefresh;

CrudAsset::register($this);

$this->registerJs('interval = '.$ar, \yii\web\VIEW::POS_HEAD);

$this->registerJs('

var s = setInterval(refresh,interval*1000)

function autorefreshChanged(){
    var e = document.getElementById("autorefresh")
    interval = e.options[e.selectedIndex].value

    $.ajax({
        url:"/bots/autorefreshchanged?a="+interval,  
        success:function(data) {
            interval = data
            clearInterval(s)
            s = setInterval(refresh,interval*1000)
        }
    })
}

function refresh(){

    if(interval > 0){
        $.pjax.reload({
        container:"#crud-datatable-pjax",
        
        })
    }
}', \yii\web\VIEW::POS_HEAD);
?>
</script>
<div class="bots-index">
    <div id="ajaxCrudDatatable">
        <?=GridView::widget([
            'moduleId' => 'gridviewKrajee',
            'id'=>'crud-datatable',
            'dataProvider' => $dataProvider,
            'filterModel' => $searchModel,
            'tableOptions' => ['class' => 'special_table table-striped table-bordered table-sm'],
            'formatter' => ['class' => 'yii\i18n\Formatter','nullDisplay' => ' '],
            //'containerOptions' => ['style' => 'overflow: auto'], // only set when $responsive = false
            'headerRowOptions' => ['class' => 'kartik-sheet-style'],
            'filterRowOptions' => ['class' => 'kartik-sheet-style'],
            'options' => [ 'style' => 'table-layout:fixed;' ],
            'pjax'=>true,
            /*'pjaxSettings'=>[
                'neverTimeout'=>true,
                'beforeGrid'=>'My fancy content before.',
                'afterGrid'=>'My fancy content after.',
            ],*/
            'rowOptions' => function ($model) {
                if ($model->status == 2) {
                        return ['class' => 'color-dead'];
                    } elseif ($model->status == 1) {
                        return ['class' => 'color-online'];
                    } elseif ($model->status == 0) {
                        return ['class' => 'color-offline'];
                    } elseif ($model->status == 3) {
                        return ['class' => 'color-newbie'];
                    }
                if ($model->busy == 1){
                    return ['class' => 'color-busy'];
                }
            },
            'resizableColumns'=>true,
            'columns' => require(__DIR__.'/_columns.php'),
            'toolbar'=> [
                ['content'=>
                    Html::a('<i class="glyphicon glyphicon-repeat"></i>', [''],
                    ['data-pjax'=>1, 'class'=>'btn btn-default', 'title'=>'Reset Grid']).
                    '{toggleData}'.
                    '{export}'
                ],
            ],          
            'striped' => true,
            'condensed' => true,
            'responsive' => true,          
            'panel' => [
                'type' => 'primary', 
                'heading' => '<i class="glyphicon glyphicon-list"></i> '.$this->title.' listing',
                'before'=>'<label><b>Autorefresh&nbsp;</b></label>'.Html::dropDownList('autorefresh', $autorefresh, ['0'=>'off','30'=>'30 sec.' ,'60'=>'1 min.', '180'=>'3 min.', '300'=>'5 min.', '600'=>'10 min.'], ['style' => ['color' => '#FF5733', 'width' => '80px'], 'id' => 'autorefresh', 'onchange' => 'autorefreshChanged()']),
                'after'=>'<div class="clearfix"></div>',
            ]
        ])?>
    </div>
</div>
<?php Modal::begin([
    "id"=>"ajaxCrudModal",
    "footer"=>"",// always need it for jquery plugin
])?>

<?php Modal::end(); ?>